@extends('installer.layout')

@section('title', 'Requirements')
@section('subtitle', 'Checking system requirements')

@section('content')
    <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">System Requirements</h2>
    
    <p style="margin-bottom: var(--spacing-lg);">
        We're checking if your server meets the following requirements needed to run the application:
    </p>
    
    <ul class="requirements-list">
        @foreach($requirements as $requirement => $passed)
            <li class="requirement-item">
                <span>{{ $requirement }}</span>
                <span class="requirement-status {{ $passed ? 'status-passed' : 'status-failed' }}">
                    @if($passed)
                        <i class="fas fa-check-circle"></i> Passed
                    @else
                        <i class="fas fa-times-circle"></i> Failed
                    @endif
                </span>
            </li>
        @endforeach
    </ul>
    
    @if(!$allPassed)
        <div style="margin-top: var(--spacing-lg);" class="alert alert-danger">
            <i class="fas fa-exclamation-triangle"></i>
            <div>
                <strong>Some requirements failed!</strong>
                <p style="margin-top: var(--spacing-xs);">
                    Please fix the failed requirements before continuing with the installation.
                </p>
            </div>
        </div>
    @else
        <div style="margin-top: var(--spacing-lg);" class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <div>
                <strong>Great!</strong>
                <p style="margin-top: var(--spacing-xs);">
                    Your system meets all the requirements. You can proceed to the next step.
                </p>
            </div>
        </div>
    @endif
@endsection

@section('footer')
    <a href="{{ route('installer.index') }}" class="btn">
        <i class="fas fa-arrow-left"></i> Back
    </a>
    @if($allPassed)
        <a href="{{ route('installer.license') }}" class="btn btn-primary">
            Next <i class="fas fa-arrow-right"></i>
        </a>
    @else
        <button class="btn btn-primary" disabled>
            Next <i class="fas fa-arrow-right"></i>
        </button>
    @endif
@endsection